#########################################################################
#                                                                       #
# Name:        OWB Housekeeping generation TCL                          #
# Author:      Roelant Vos 				                                      #
# Purpose:     Generation of housekeeping processes                     #
#                                                                       #
#########################################################################


source C:/TCL/settings.tcl

puts ""
puts "\nConnecting to OWB Metadata Repository, project: $project\n"


##################################
# General connection information #
##################################

OMBDISCONNECT
OMBCONNECT $OWB_repository/$OWB_password@$OWB_server:1521:$environment
OMBCC '$project'


puts ""
puts "Processing source module $IntMod"
puts ""

########################
# Table array creation #      
########################

OMBCC '$IntMod'

set targetTableList     [OMBLIST TABLES 'MD_.*']
set targetMapList       [OMBLIST MAPPINGS 'M_MD.*']
set targetFunctionList  [OMBLIST FUNCTIONS]
set targetProcedureList [OMBLIST PROCEDURES]

############################### 
# Functions and procedures    #
###############################

puts "Currently no housekeeping processes are defined"

puts "Generation ready"

OMBCOMMIT        
OMBDISCONNECT